/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.client;

import com.ibm.hsc.client.PIDataBeanInterface;
import com.ibm.hsc.common.util.ByteUtilities;
import com.ibm.hsc.common.util.CSVRecord;
import com.ibm.hsc.common.util.PIHscUtil;
import java.util.Hashtable;
import org.snia.wbem.cim.CIMInstance;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt32;

public class PIIOBusDataBean
implements PIDataBeanInterface {
    public static final String KEY_DRAWER_LOC_CODE = "unit_phys_loc";
    public static final String KEY_DRAWER_ID = "unit_id";
    public static final String KEY_BUS_ID = "bus_id";
    public static final String KEY_BUS_CLASS = "bus_class";
    public static final String KEY_BUS_BACKPLAN_LOC = "backplane_phys_loc";
    public static final String KEY_BUS_DRC_INDEX = "bus_drc_index";
    public static final String KEY_BUS_DRC_NAME = "bus_drc_name";
    public static final String[] ALL_KEYS = new String[]{"unit_id", "bus_id", "bus_class", "backplane_phys_loc", "bus_drc_name"};
    private String m_drawerLocCode = null;
    private String m_drawerID = null;
    private String m_busID = null;
    private String m_busLocationCode = null;
    private UnsignedInt16 m_numSlots = null;
    private UnsignedInt32 m_busDrcIndex = null;
    private String m_busDrcName = null;
    private Hashtable m_slots = null;

    public PIIOBusDataBean() {
    }

    public PIIOBusDataBean(String string, String string2, UnsignedInt16 unsignedInt16, CIMInstance cIMInstance) {
        this.m_drawerLocCode = string;
        this.m_drawerID = string2;
        this.m_busID = (String)PIHscUtil.getCIMAttrValue(cIMInstance, "DeviceID");
        this.m_busLocationCode = (String)PIHscUtil.getCIMAttrValue(cIMInstance, "LocationCode");
        this.m_busDrcIndex = (UnsignedInt32)PIHscUtil.getCIMAttrValue(cIMInstance, "DrcIndex");
        this.m_numSlots = unsignedInt16;
        this.m_busDrcName = (String)PIHscUtil.getCIMAttrValue(cIMInstance, "DrcName");
    }

    public String[] getAllKeys() {
        return ALL_KEYS;
    }

    public String getDrawerLocCode() {
        return this.m_drawerLocCode;
    }

    public void setDrawerLocCode(String string) {
        this.m_drawerLocCode = string;
    }

    public String getDrawerID() {
        return this.m_drawerID;
    }

    public void setDrawerID(String string) {
        this.m_drawerID = string;
    }

    public boolean drawerIDMatch(String string) {
        if (null != this.m_drawerID) {
            return this.m_drawerID.equals(string);
        }
        return false;
    }

    public String getBusID() {
        return this.m_busID;
    }

    public void setBusID(String string) {
        this.m_busID = string;
    }

    public UnsignedInt32 getBusDrcIndex() {
        return this.m_busDrcIndex;
    }

    public void setBusDrcIndex(UnsignedInt32 unsignedInt32) {
        this.m_busDrcIndex = unsignedInt32;
    }

    public String getBusDrcName() {
        return this.m_busDrcName;
    }

    public void setBusDrcName(String string) {
        this.m_busDrcName = string;
    }

    public String getBusLocationCode() {
        return this.m_busLocationCode;
    }

    public void setBusLocationCode(String string) {
        this.m_busLocationCode = string;
    }

    public UnsignedInt16 getNumSlots() {
        return this.m_numSlots;
    }

    public void setNumSlots(UnsignedInt16 unsignedInt16) {
        this.m_numSlots = unsignedInt16;
    }

    public Hashtable getSlots() {
        return this.m_slots;
    }

    public void setSlots(Hashtable hashtable) {
        this.m_slots = hashtable;
    }

    public String toString(String[] stringArray, boolean bl, String string) {
        CSVRecord cSVRecord = new CSVRecord(true, string);
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (KEY_DRAWER_LOC_CODE.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, this.m_drawerLocCode, bl);
                continue;
            }
            if (KEY_BUS_ID.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, this.m_busID, bl);
                continue;
            }
            if (KEY_BUS_BACKPLAN_LOC.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, this.m_busLocationCode, bl);
                continue;
            }
            if (KEY_BUS_DRC_INDEX.equals(string2)) {
                if (this.m_busDrcIndex != null) {
                    CSVRecord.append(cSVRecord, string2, ByteUtilities.toHexString((Number)this.m_busDrcIndex, 8), bl);
                    continue;
                }
                CSVRecord.append(cSVRecord, string2, (String)null, bl);
                continue;
            }
            if (!KEY_BUS_DRC_NAME.equals(string2)) continue;
            CSVRecord.append(cSVRecord, string2, this.m_busDrcName, bl);
        }
        return cSVRecord.toString();
    }

    public String toString() {
        return "[" + this.toString(ALL_KEYS, true, ",") + "]";
    }
}

